/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.adventurez.entity.MiniBlackstoneGolemEntity;
import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlackstoneGolemEntity
extends Monster {
    public static final EntityDataAccessor<Integer> THROW_COOLDOWN;
    public static final EntityDataAccessor<Boolean> INVULNERABLE;
    public static final EntityDataAccessor<Integer> INVULNERABLE_TIMER;
    public static final EntityDataAccessor<Integer> LAVA_TEXTURE;
    public static final EntityDataAccessor<Boolean> HALF_LIFE_CHANGE;
    private static final UUID WALKING_SPEED_INCREASE_ID;
    private static final AttributeModifier WALKING_SPEED_INCREASE;
    private static final Predicate<Entity> NOT_STONEGOLEM;
    private int cooldown = 0;
    private int thrownStoneCooldown = 120;
    private int attackTick;
    private int stunTick;
    private int roarTick;
    private int powerPhaseActivate = 0;
    private int lavaRegenerateLife = 0;
    private final ServerBossEvent bossBar;

    public BlackstoneGolemEntity(EntityType<? extends BlackstoneGolemEntity> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 200;
        this.bossBar = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    }

    public static AttributeSupplier.Builder createStoneGolemAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 600.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22278_, 2.5).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22282_, 2.8).m_22268_(Attributes.f_22277_, 38.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 60.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AttackTick", this.attackTick);
        tag.m_128405_("StunTick", this.stunTick);
        tag.m_128405_("RoarTick", this.roarTick);
        tag.m_128405_("Invul", this.getInvulnerableTimer());
        tag.m_128405_("LavaTexture", this.getLavaTexture());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.attackTick = tag.m_128451_("AttackTick");
        this.stunTick = tag.m_128451_("StunTick");
        this.roarTick = tag.m_128451_("RoarTick");
        this.setInvulTimer(tag.m_128451_("Invul"));
        this.setLavaTexture(tag.m_128451_("LavaTexture"));
        if (this.m_8077_()) {
            this.bossBar.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossBar.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(THROW_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(INVULNERABLE, (Object)true);
        this.f_19804_.m_135372_(LAVA_TEXTURE, (Object)400);
        this.f_19804_.m_135372_(HALF_LIFE_CHANGE, (Object)false);
        this.f_19804_.m_135372_(INVULNERABLE_TIMER, (Object)0);
    }

    protected PathNavigation m_6037_(Level world) {
        return new Navigation((Mob)this, world);
    }

    public boolean m_142079_() {
        return false;
    }

    public void m_8024_() {
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected float m_6121_() {
        return 1.3f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (this.getInvulnerableTimer() > 0) {
                this.setInvulTimer(this.getInvulnerableTimer() - 1);
            }
            if (this.getInvulnerableTimer() == 0) {
                if (this.getLavaTexture() < 400) {
                    this.setLavaTexture(this.getLavaTexture() + 1);
                }
                if (((Boolean)this.f_19804_.m_135370_(INVULNERABLE)).booleanValue()) {
                    this.f_19804_.m_135381_(INVULNERABLE, (Object)false);
                    this.m_5496_(SoundInit.GOLEM_AWAKENS_EVENT, 2.0f, 1.0f);
                }
            }
            if (this.m_21223_() <= this.m_21233_() / 2.0f) {
                if (this.powerPhaseActivate <= 80) {
                    ++this.powerPhaseActivate;
                    if (this.powerPhaseActivate == 1 || this.powerPhaseActivate == 2) {
                        this.m_21557_(true);
                    }
                    if (this.powerPhaseActivate == 78 || this.powerPhaseActivate == 79) {
                        this.m_21557_(false);
                        this.roar();
                    }
                }
                if (this.powerPhaseActivate == 80) {
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
                    this.m_21051_(Attributes.f_22282_).m_22100_(4.0);
                    this.f_19804_.m_135381_(HALF_LIFE_CHANGE, (Object)true);
                }
            } else if (this.m_20077_() && this.m_21223_() < this.m_21233_()) {
                ++this.lavaRegenerateLife;
                if (this.lavaRegenerateLife >= 200) {
                    this.m_21153_(this.m_21223_() + 2.0f);
                    this.lavaRegenerateLife = 0;
                }
            }
            if (this.f_19862_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                boolean bl = false;
                AABB box = this.m_20191_().m_82400_(0.25);
                Iterator var8 = BlockPos.m_121976_((int)Mth.m_14107_((double)box.f_82288_), (int)Mth.m_14107_((double)(box.f_82289_ + 0.25)), (int)Mth.m_14107_((double)box.f_82290_), (int)Mth.m_14107_((double)box.f_82291_), (int)Mth.m_14107_((double)(box.f_82292_ + 0.4)), (int)Mth.m_14107_((double)box.f_82293_)).iterator();
                while (true) {
                    if (!var8.hasNext()) {
                        if (bl || !this.m_20096_()) break;
                        this.m_6135_();
                        break;
                    }
                    BlockPos blockPos = (BlockPos)var8.next();
                    BlockState blockState = this.m_9236_().m_8055_(blockPos);
                    Block block = blockState.m_60734_();
                    if (!(block instanceof Block) || blockState.m_204336_(TagInit.UNBREAKABLE_BLOCKS)) continue;
                    bl = this.m_9236_().m_46953_(blockPos, true, (Entity)this) || bl;
                }
            }
            if (this.roarTick > 0) {
                --this.roarTick;
                if (this.roarTick == 10) {
                    this.roar();
                }
            }
            if (this.attackTick > 0) {
                --this.attackTick;
            }
            if (this.stunTick > 0) {
                --this.stunTick;
                this.spawnStunnedParticles();
                if (this.stunTick == 0) {
                    this.m_5496_(SoundInit.GOLEM_ROAR_EVENT, 1.0f, 1.0f);
                    this.roarTick = 30;
                }
            }
            if (this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.m_20280_((Entity)this.m_5448_()) < 1400.0 && this.m_20280_((Entity)this.m_5448_()) > 100.0) {
                this.f_19804_.m_135381_(THROW_COOLDOWN, (Object)this.cooldown);
                ++this.cooldown;
                if (this.cooldown == this.thrownStoneCooldown - 10) {
                    this.m_5496_(SoundInit.GOLEM_ROAR_EVENT, 1.0f, 1.0f);
                    this.throwRock(this.m_5448_());
                }
                if (this.cooldown >= this.thrownStoneCooldown) {
                    this.cooldown = -80;
                }
            }
            if (this.m_6046_() && !this.m_21204_().m_22154_(Attributes.f_22279_, WALKING_SPEED_INCREASE_ID)) {
                this.m_21051_(Attributes.f_22279_).m_22118_(WALKING_SPEED_INCREASE);
            } else if (!this.m_6046_() && this.m_21204_().m_22154_(Attributes.f_22279_, WALKING_SPEED_INCREASE_ID)) {
                this.m_21051_(Attributes.f_22279_).m_22120_(WALKING_SPEED_INCREASE_ID);
            }
            if (this.m_20077_()) {
                this.m_20256_(this.m_20184_().m_82490_(1.9));
            }
        }
    }

    private void spawnStunnedParticles() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double e = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double f = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, d, e, f, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.attackTick > 0 || this.stunTick > 0 || this.roarTick > 0 || this.cooldown > this.thrownStoneCooldown - 30 && this.cooldown > 0 || (Boolean)this.m_20088_().m_135370_(INVULNERABLE) != false;
    }

    public boolean m_142582_(Entity entity) {
        return this.stunTick <= 0 && this.roarTick <= 0 ? super.m_142582_(entity) : false;
    }

    protected void m_6731_(LivingEntity target) {
        if (this.roarTick == 0) {
            if (this.f_19796_.m_188500_() < 0.5) {
                this.stunTick = 40;
                this.m_5496_(SoundInit.GOLEM_IDLE_EVENT, 1.0f, 1.0f);
                this.m_9236_().m_7605_((Entity)this, (byte)39);
                target.m_7334_((Entity)this);
            } else {
                this.knockBack((Entity)target);
            }
            target.f_19864_ = true;
        }
    }

    private void roar() {
        if (this.m_6084_()) {
            List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(5.0), NOT_STONEGOLEM);
            for (LivingEntity entity : list) {
                entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 10.0f);
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.63, 0.0));
                this.knockBack((Entity)entity);
            }
            Vec3 vec3d = this.m_20191_().m_82399_();
            for (int i = 0; i < 50; ++i) {
                double d = this.f_19796_.m_188583_() * 0.2;
                double e = this.f_19796_.m_188583_() * 0.2;
                double f = this.f_19796_.m_188583_() * 0.2;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, d, e, f);
            }
        }
    }

    private void knockBack(Entity entity) {
        double d = entity.m_20185_() - this.m_20185_();
        double e = entity.m_20189_() - this.m_20189_();
        double f = Math.max(d * d + e * e, 0.001);
        entity.m_5997_(d / f * 4.0, 0.2, e / f * 4.0);
    }

    @Environment(value=EnvType.CLIENT)
    public void m_7822_(byte status) {
        if (status == 4) {
            this.attackTick = 10;
            this.m_5496_(SoundInit.GOLEM_HIT_EVENT, 1.0f, 1.0f);
        } else if (status == 39) {
            this.stunTick = 40;
        }
        super.m_7822_(status);
    }

    @Environment(value=EnvType.CLIENT)
    public int getAttackTick() {
        return this.attackTick;
    }

    @Environment(value=EnvType.CLIENT)
    public int getStunTick() {
        return this.stunTick;
    }

    @Environment(value=EnvType.CLIENT)
    public int getRoarTick() {
        return this.roarTick;
    }

    public boolean m_7327_(Entity target) {
        this.attackTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundInit.GOLEM_HIT_EVENT, 1.0f, 1.0f);
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).m_20254_(3 + this.m_9236_().m_213780_().m_188503_(6));
        }
        return super.m_7327_(target);
    }

    protected SoundEvent m_7515_() {
        if (((Boolean)this.m_20088_().m_135370_(INVULNERABLE)).booleanValue()) {
            return null;
        }
        return SoundInit.GOLEM_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.GOLEM_HIT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.GOLEM_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundInit.GOLEM_WALK_EVENT, 0.15f, 1.0f);
    }

    public boolean m_6914_(LevelReader world) {
        return !world.m_46855_(this.m_20191_());
    }

    public boolean m_6785_(double num) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public boolean m_6072_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (((Boolean)this.m_20088_().m_135370_(INVULNERABLE)).booleanValue()) {
            return false;
        }
        if (source.m_7640_() instanceof LivingEntity) {
            this.m_6703_((LivingEntity)source.m_7640_());
            this.m_6710_((LivingEntity)source.m_7640_());
            if (this.m_9236_().m_213780_().m_188501_() <= 0.05f) {
                MiniBlackstoneGolemEntity smallStoneGolemEntity = (MiniBlackstoneGolemEntity)EntityInit.MINI_BLACKSTONE_GOLEM.m_20615_(this.m_9236_());
                smallStoneGolemEntity.m_20035_(this.m_20183_(), this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)smallStoneGolemEntity);
            }
        }
        return super.m_6469_(source, amount);
    }

    private void throwRock(LivingEntity target) {
        double z_vector;
        double x_vector;
        Vec3 vec3d_1 = this.m_20252_(1.0f);
        if (vec3d_1.f_82479_ < 0.0 && vec3d_1.f_82481_ < 0.0) {
            x_vector = vec3d_1.f_82479_ + 1.8;
            z_vector = vec3d_1.f_82481_ - 2.8;
        } else if (vec3d_1.f_82479_ < 0.0 && vec3d_1.f_82481_ > 0.0) {
            x_vector = vec3d_1.f_82479_ - 1.8;
            z_vector = vec3d_1.f_82481_ - 2.8;
        } else if (vec3d_1.f_82479_ > 0.0 && vec3d_1.f_82481_ < 0.0) {
            x_vector = vec3d_1.f_82479_ + 1.8;
            z_vector = vec3d_1.f_82481_ + 2.8;
        } else if (vec3d_1.f_82479_ > 0.0 && vec3d_1.f_82481_ > 0.0) {
            x_vector = vec3d_1.f_82479_ - 1.8;
            z_vector = vec3d_1.f_82481_ + 2.8;
        } else {
            x_vector = vec3d_1.f_82479_ + 1.8;
            z_vector = vec3d_1.f_82481_ - 2.8;
        }
        double x = target.m_20185_() - this.m_20185_() - x_vector;
        double y = target.m_20227_(1.0) - this.m_20227_(0.1);
        double z = target.m_20189_() - this.m_20189_() - z_vector;
        ThrownRockEntity thrownRockEntity = new ThrownRockEntity(this.m_9236_(), this.m_20185_() + x_vector, this.m_20186_() + 0.5, this.m_20189_() + z_vector);
        thrownRockEntity.m_5602_((Entity)this);
        if (!this.m_9236_().m_5776_()) {
            if (this.m_20280_((Entity)this.m_5448_()) < 800.0) {
                thrownRockEntity.m_6686_(x, y, z, 1.8f, 3.0f);
                this.m_9236_().m_7967_((Entity)thrownRockEntity);
            } else {
                thrownRockEntity.m_6686_(x, y + 4.0, z, 1.8f, 2.0f);
                this.m_9236_().m_7967_((Entity)thrownRockEntity);
            }
        }
    }

    public void sendtoEntity() {
        this.setInvulTimer(220);
        this.setLavaTexture(0);
    }

    public int getInvulnerableTimer() {
        return (Integer)this.f_19804_.m_135370_(INVULNERABLE_TIMER);
    }

    public void setInvulTimer(int ticks) {
        this.f_19804_.m_135381_(INVULNERABLE_TIMER, (Object)ticks);
    }

    public int getLavaTexture() {
        return (Integer)this.f_19804_.m_135370_(LAVA_TEXTURE);
    }

    public void setLavaTexture(int ticks) {
        this.f_19804_.m_135381_(LAVA_TEXTURE, (Object)ticks);
    }

    public void m_6667_(DamageSource source) {
        if (!this.m_9236_().m_5776_()) {
            MiniBlackstoneGolemEntity smallStoneGolemEntity = (MiniBlackstoneGolemEntity)EntityInit.MINI_BLACKSTONE_GOLEM.m_20615_(this.m_9236_());
            MiniBlackstoneGolemEntity smallStoneGolemEntitySecond = (MiniBlackstoneGolemEntity)EntityInit.MINI_BLACKSTONE_GOLEM.m_20615_(this.m_9236_());
            smallStoneGolemEntity.m_20035_(this.m_20183_().m_122029_(), this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
            smallStoneGolemEntitySecond.m_20035_(this.m_20183_().m_122024_(), this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
            this.m_9236_().m_7967_((Entity)smallStoneGolemEntity);
            this.m_9236_().m_7967_((Entity)smallStoneGolemEntitySecond);
        }
        super.m_6667_(source);
    }

    static {
        NOT_STONEGOLEM = entity -> entity.m_6084_() && !(entity instanceof BlackstoneGolemEntity);
        THROW_COOLDOWN = SynchedEntityData.m_135353_(BlackstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        INVULNERABLE = SynchedEntityData.m_135353_(BlackstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        INVULNERABLE_TIMER = SynchedEntityData.m_135353_(BlackstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        LAVA_TEXTURE = SynchedEntityData.m_135353_(BlackstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        HALF_LIFE_CHANGE = SynchedEntityData.m_135353_(BlackstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        WALKING_SPEED_INCREASE_ID = UUID.fromString("766bfa64-11f3-11ea-8d71-362b9e155667");
        WALKING_SPEED_INCREASE = new AttributeModifier(WALKING_SPEED_INCREASE_ID, "LavaAndSoulSpeed", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)BlackstoneGolemEntity.this, 1.0, true);
        }

        public double m_6639_(LivingEntity entity) {
            float f = BlackstoneGolemEntity.this.m_20205_() - 0.1f;
            return f * f * 1.5f + entity.m_20205_();
        }
    }

    static class Navigation
    extends GroundPathNavigation {
        public Navigation(Mob mobEntity, Level world) {
            super(mobEntity, world);
        }

        protected PathFinder m_5532_(int range) {
            this.f_26508_ = new PathNodeMaker();
            return new PathFinder(this.f_26508_, range);
        }
    }

    static class PathNodeMaker
    extends WalkNodeEvaluator {
        private PathNodeMaker() {
        }

        protected BlockPathTypes m_264405_(BlockGetter world, BlockPos pos, BlockPathTypes type) {
            return type == BlockPathTypes.LAVA ? BlockPathTypes.OPEN : super.m_264405_(world, pos, type);
        }
    }
}

